import random

# Function to read words from a file
def read_words(filename):
    with open(filename, 'r') as file:
        return [word.strip() for word in file.readlines()]

# Read adjectives, nouns, and numbers
adjectives = read_words("adjectives.txt")
nouns = read_words("nouns.txt")
numbers = [str(num).zfill(3) for num in range(1000)]

# Open output file for writing
with open("ARLOdevice.txt", 'w') as output_file:
    # Generate and write combinations
    for adj in adjectives:
        for noun in nouns:
            for num in numbers:
                combination = f"{adj}{noun}{num}\n"
                output_file.write(combination)

print("Wordlist generated successfully and saved to ARLOdevice.txt.")
